/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.vet;

import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.samples.petclinic.vet.Vet;
import org.springframework.samples.petclinic.vet.VetRepository;
import org.springframework.samples.petclinic.vet.Vets;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
class VetController {
    private final VetRepository vetRepository;

    public VetController(VetRepository clinicService) {
        this.vetRepository = clinicService;
    }

    @GetMapping(value={"/vets.html"})
    public String showVetList(@RequestParam(defaultValue="1") int page, Model model) {
        Vets vets = new Vets();
        Page paginated = this.findPaginated(page);
        vets.getVetList().addAll(paginated.toList());
        return this.addPaginationModel(page, paginated, model);
    }

    private String addPaginationModel(int page, Page<Vet> paginated, Model model) {
        List listVets = paginated.getContent();
        model.addAttribute("currentPage", (Object)page);
        model.addAttribute("totalPages", (Object)paginated.getTotalPages());
        model.addAttribute("totalItems", (Object)paginated.getTotalElements());
        model.addAttribute("listVets", (Object)listVets);
        return "vets/vetList";
    }

    private Page<Vet> findPaginated(int page) {
        int pageSize = 5;
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)pageSize);
        return this.vetRepository.findAll((Pageable)pageable);
    }

    @GetMapping(value={"/vets"})
    @ResponseBody
    public Vets showResourcesVetList() {
        Vets vets = new Vets();
        vets.getVetList().addAll(this.vetRepository.findAll());
        return vets;
    }
}

