/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.owner;

import jakarta.validation.Valid;
import java.util.Map;
import org.springframework.samples.petclinic.owner.Owner;
import org.springframework.samples.petclinic.owner.OwnerRepository;
import org.springframework.samples.petclinic.owner.Pet;
import org.springframework.samples.petclinic.owner.Visit;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
class VisitController {
    private final OwnerRepository owners;

    public VisitController(OwnerRepository owners) {
        this.owners = owners;
    }

    @InitBinder
    public void setAllowedFields(WebDataBinder dataBinder) {
        dataBinder.setDisallowedFields(new String[]{"id"});
    }

    @ModelAttribute(value="visit")
    public Visit loadPetWithVisit(@PathVariable(value="ownerId") int ownerId, @PathVariable(value="petId") int petId, Map<String, Object> model) {
        Owner owner = this.owners.findById(Integer.valueOf(ownerId));
        Pet pet = owner.getPet(Integer.valueOf(petId));
        model.put("pet", pet);
        model.put("owner", owner);
        Visit visit = new Visit();
        pet.addVisit(visit);
        return visit;
    }

    @GetMapping(value={"/owners/{ownerId}/pets/{petId}/visits/new"})
    public String initNewVisitForm() {
        return "pets/createOrUpdateVisitForm";
    }

    @PostMapping(value={"/owners/{ownerId}/pets/{petId}/visits/new"})
    public String processNewVisitForm(@ModelAttribute Owner owner, @PathVariable int petId, @Valid Visit visit, BindingResult result, RedirectAttributes redirectAttributes) {
        if (result.hasErrors()) {
            return "pets/createOrUpdateVisitForm";
        }
        owner.addVisit(Integer.valueOf(petId), visit);
        this.owners.save(owner);
        redirectAttributes.addFlashAttribute("message", (Object)"Your visit has been booked");
        return "redirect:/owners/{ownerId}";
    }
}

