/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.owner;

import org.springframework.samples.petclinic.owner.Pet;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class PetValidator
implements Validator {
    private static final String REQUIRED = "required";

    public void validate(Object obj, Errors errors) {
        Pet pet = (Pet)obj;
        String name = pet.getName();
        if (!StringUtils.hasText((String)name)) {
            errors.rejectValue("name", REQUIRED, REQUIRED);
        }
        if (pet.isNew() && pet.getType() == null) {
            errors.rejectValue("type", REQUIRED, REQUIRED);
        }
        if (pet.getBirthDate() == null) {
            errors.rejectValue("birthDate", REQUIRED, REQUIRED);
        }
    }

    public boolean supports(Class<?> clazz) {
        return Pet.class.isAssignableFrom(clazz);
    }
}

