/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.owner;

import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.Formatter;
import org.springframework.samples.petclinic.owner.OwnerRepository;
import org.springframework.samples.petclinic.owner.PetType;
import org.springframework.stereotype.Component;

@Component
public class PetTypeFormatter
implements Formatter<PetType> {
    private final OwnerRepository owners;

    @Autowired
    public PetTypeFormatter(OwnerRepository owners) {
        this.owners = owners;
    }

    public String print(PetType petType, Locale locale) {
        return petType.getName();
    }

    public PetType parse(String text, Locale locale) throws ParseException {
        List findPetTypes = this.owners.findPetTypes();
        for (PetType type : findPetTypes) {
            if (!type.getName().equals(text)) continue;
            return type;
        }
        throw new ParseException("type not found: " + text, 0);
    }
}

