/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.owner;

import jakarta.validation.Valid;
import java.time.LocalDate;
import java.util.Collection;
import org.springframework.samples.petclinic.owner.Owner;
import org.springframework.samples.petclinic.owner.OwnerRepository;
import org.springframework.samples.petclinic.owner.Pet;
import org.springframework.samples.petclinic.owner.PetType;
import org.springframework.samples.petclinic.owner.PetValidator;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/owners/{ownerId}"})
class PetController {
    private static final String VIEWS_PETS_CREATE_OR_UPDATE_FORM = "pets/createOrUpdatePetForm";
    private final OwnerRepository owners;

    public PetController(OwnerRepository owners) {
        this.owners = owners;
    }

    @ModelAttribute(value="types")
    public Collection<PetType> populatePetTypes() {
        return this.owners.findPetTypes();
    }

    @ModelAttribute(value="owner")
    public Owner findOwner(@PathVariable(value="ownerId") int ownerId) {
        Owner owner = this.owners.findById(Integer.valueOf(ownerId));
        if (owner == null) {
            throw new IllegalArgumentException("Owner ID not found: " + ownerId);
        }
        return owner;
    }

    @ModelAttribute(value="pet")
    public Pet findPet(@PathVariable(value="ownerId") int ownerId, @PathVariable(name="petId", required=false) Integer petId) {
        if (petId == null) {
            return new Pet();
        }
        Owner owner = this.owners.findById(Integer.valueOf(ownerId));
        if (owner == null) {
            throw new IllegalArgumentException("Owner ID not found: " + ownerId);
        }
        return owner.getPet(petId);
    }

    @InitBinder(value={"owner"})
    public void initOwnerBinder(WebDataBinder dataBinder) {
        dataBinder.setDisallowedFields(new String[]{"id"});
    }

    @InitBinder(value={"pet"})
    public void initPetBinder(WebDataBinder dataBinder) {
        dataBinder.setValidator((Validator)new PetValidator());
    }

    @GetMapping(value={"/pets/new"})
    public String initCreationForm(Owner owner, ModelMap model) {
        Pet pet = new Pet();
        owner.addPet(pet);
        model.put((Object)"pet", (Object)pet);
        return VIEWS_PETS_CREATE_OR_UPDATE_FORM;
    }

    @PostMapping(value={"/pets/new"})
    public String processCreationForm(Owner owner, @Valid Pet pet, BindingResult result, ModelMap model, RedirectAttributes redirectAttributes) {
        if (StringUtils.hasText((String)pet.getName()) && pet.isNew() && owner.getPet(pet.getName(), true) != null) {
            result.rejectValue("name", "duplicate", "already exists");
        }
        LocalDate currentDate = LocalDate.now();
        if (pet.getBirthDate() != null && pet.getBirthDate().isAfter(currentDate)) {
            result.rejectValue("birthDate", "typeMismatch.birthDate");
        }
        owner.addPet(pet);
        if (result.hasErrors()) {
            model.put((Object)"pet", (Object)pet);
            return VIEWS_PETS_CREATE_OR_UPDATE_FORM;
        }
        this.owners.save(owner);
        redirectAttributes.addFlashAttribute("message", (Object)"New Pet has been Added");
        return "redirect:/owners/{ownerId}";
    }

    @GetMapping(value={"/pets/{petId}/edit"})
    public String initUpdateForm(Owner owner, @PathVariable(value="petId") int petId, ModelMap model, RedirectAttributes redirectAttributes) {
        Pet pet = owner.getPet(Integer.valueOf(petId));
        model.put((Object)"pet", (Object)pet);
        return VIEWS_PETS_CREATE_OR_UPDATE_FORM;
    }

    @PostMapping(value={"/pets/{petId}/edit"})
    public String processUpdateForm(@Valid Pet pet, BindingResult result, Owner owner, ModelMap model, RedirectAttributes redirectAttributes) {
        Pet existingPet;
        String petName = pet.getName();
        if (StringUtils.hasText((String)petName) && (existingPet = owner.getPet(petName.toLowerCase(), false)) != null && existingPet.getId() != pet.getId()) {
            result.rejectValue("name", "duplicate", "already exists");
        }
        LocalDate currentDate = LocalDate.now();
        if (pet.getBirthDate() != null && pet.getBirthDate().isAfter(currentDate)) {
            result.rejectValue("birthDate", "typeMismatch.birthDate");
        }
        if (result.hasErrors()) {
            model.put((Object)"pet", (Object)pet);
            return VIEWS_PETS_CREATE_OR_UPDATE_FORM;
        }
        owner.addPet(pet);
        this.owners.save(owner);
        redirectAttributes.addFlashAttribute("message", (Object)"Pet details has been edited");
        return "redirect:/owners/{ownerId}";
    }
}

