/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.owner;

import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.Param;
import org.springframework.samples.petclinic.owner.Owner;
import org.springframework.samples.petclinic.owner.PetType;
import org.springframework.transaction.annotation.Transactional;

public interface OwnerRepository
extends Repository<Owner, Integer> {
    @Query(value="SELECT ptype FROM PetType ptype ORDER BY ptype.name")
    @Transactional(readOnly=true)
    public List<PetType> findPetTypes();

    @Query(value="SELECT DISTINCT owner FROM Owner owner left join  owner.pets WHERE owner.lastName LIKE :lastName% ")
    @Transactional(readOnly=true)
    public Page<Owner> findByLastName(@Param(value="lastName") String var1, Pageable var2);

    @Query(value="SELECT owner FROM Owner owner left join fetch owner.pets WHERE owner.id =:id")
    @Transactional(readOnly=true)
    public Owner findById(@Param(value="id") Integer var1);

    public void save(Owner var1);

    @Query(value="SELECT owner FROM Owner owner")
    @Transactional(readOnly=true)
    public Page<Owner> findAll(Pageable var1);
}

