/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.owner;

import jakarta.validation.Valid;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.samples.petclinic.owner.Owner;
import org.springframework.samples.petclinic.owner.OwnerRepository;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
class OwnerController {
    private static final String VIEWS_OWNER_CREATE_OR_UPDATE_FORM = "owners/createOrUpdateOwnerForm";
    private final OwnerRepository owners;

    public OwnerController(OwnerRepository clinicService) {
        this.owners = clinicService;
    }

    @InitBinder
    public void setAllowedFields(WebDataBinder dataBinder) {
        dataBinder.setDisallowedFields(new String[]{"id"});
    }

    @ModelAttribute(value="owner")
    public Owner findOwner(@PathVariable(name="ownerId", required=false) Integer ownerId) {
        return ownerId == null ? new Owner() : this.owners.findById(ownerId);
    }

    @GetMapping(value={"/owners/new"})
    public String initCreationForm(Map<String, Object> model) {
        Owner owner = new Owner();
        model.put("owner", owner);
        return VIEWS_OWNER_CREATE_OR_UPDATE_FORM;
    }

    @PostMapping(value={"/owners/new"})
    public String processCreationForm(@Valid Owner owner, BindingResult result, RedirectAttributes redirectAttributes) {
        if (result.hasErrors()) {
            redirectAttributes.addFlashAttribute("error", (Object)"There was an error in creating the owner.");
            return VIEWS_OWNER_CREATE_OR_UPDATE_FORM;
        }
        this.owners.save(owner);
        redirectAttributes.addFlashAttribute("message", (Object)"New Owner Created");
        return "redirect:/owners/" + owner.getId();
    }

    @GetMapping(value={"/owners/find"})
    public String initFindForm() {
        return "owners/findOwners";
    }

    @GetMapping(value={"/owners"})
    public String processFindForm(@RequestParam(defaultValue="1") int page, Owner owner, BindingResult result, Model model) {
        Page ownersResults;
        if (owner.getLastName() == null) {
            owner.setLastName("");
        }
        if ((ownersResults = this.findPaginatedForOwnersLastName(page, owner.getLastName())).isEmpty()) {
            result.rejectValue("lastName", "notFound", "not found");
            return "owners/findOwners";
        }
        if (ownersResults.getTotalElements() == 1L) {
            owner = (Owner)ownersResults.iterator().next();
            return "redirect:/owners/" + owner.getId();
        }
        return this.addPaginationModel(page, model, ownersResults);
    }

    private String addPaginationModel(int page, Model model, Page<Owner> paginated) {
        List listOwners = paginated.getContent();
        model.addAttribute("currentPage", (Object)page);
        model.addAttribute("totalPages", (Object)paginated.getTotalPages());
        model.addAttribute("totalItems", (Object)paginated.getTotalElements());
        model.addAttribute("listOwners", (Object)listOwners);
        return "owners/ownersList";
    }

    private Page<Owner> findPaginatedForOwnersLastName(int page, String lastname) {
        int pageSize = 5;
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)pageSize);
        return this.owners.findByLastName(lastname, (Pageable)pageable);
    }

    @GetMapping(value={"/owners/{ownerId}/edit"})
    public String initUpdateOwnerForm(@PathVariable(value="ownerId") int ownerId, Model model) {
        Owner owner = this.owners.findById(Integer.valueOf(ownerId));
        model.addAttribute((Object)owner);
        return VIEWS_OWNER_CREATE_OR_UPDATE_FORM;
    }

    @PostMapping(value={"/owners/{ownerId}/edit"})
    public String processUpdateOwnerForm(@Valid Owner owner, BindingResult result, @PathVariable(value="ownerId") int ownerId, RedirectAttributes redirectAttributes) {
        if (result.hasErrors()) {
            redirectAttributes.addFlashAttribute("error", (Object)"There was an error in updating the owner.");
            return VIEWS_OWNER_CREATE_OR_UPDATE_FORM;
        }
        owner.setId(Integer.valueOf(ownerId));
        this.owners.save(owner);
        redirectAttributes.addFlashAttribute("message", (Object)"Owner Values Updated");
        return "redirect:/owners/{ownerId}";
    }

    @GetMapping(value={"/owners/{ownerId}"})
    public ModelAndView showOwner(@PathVariable(value="ownerId") int ownerId) {
        ModelAndView mav = new ModelAndView("owners/ownerDetails");
        Owner owner = this.owners.findById(Integer.valueOf(ownerId));
        mav.addObject((Object)owner);
        return mav;
    }
}

