/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.petclinic.owner;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.style.ToStringCreator;
import org.springframework.samples.petclinic.model.Person;
import org.springframework.samples.petclinic.owner.Pet;
import org.springframework.samples.petclinic.owner.Visit;
import org.springframework.util.Assert;

@Entity
@Table(name="owners")
public class Owner
extends Person {
    @Column(name="address")
    @NotBlank
    private String address;
    @Column(name="city")
    @NotBlank
    private String city;
    @Column(name="telephone")
    @NotBlank
    @Pattern(regexp="\\d{10}", message="Telephone must be a 10-digit number")
    private @NotBlank @Pattern(regexp="\\d{10}", message="Telephone must be a 10-digit number") String telephone;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="owner_id")
    @OrderBy(value="name")
    private List<Pet> pets = new ArrayList();

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public List<Pet> getPets() {
        return this.pets;
    }

    public void addPet(Pet pet) {
        if (pet.isNew()) {
            this.getPets().add(pet);
        }
    }

    public Pet getPet(String name) {
        return this.getPet(name, false);
    }

    public Pet getPet(Integer id) {
        for (Pet pet : this.getPets()) {
            Integer compId;
            if (pet.isNew() || !(compId = pet.getId()).equals(id)) continue;
            return pet;
        }
        return null;
    }

    public Pet getPet(String name, boolean ignoreNew) {
        name = name.toLowerCase();
        for (Pet pet : this.getPets()) {
            String compName = pet.getName();
            if (compName == null || !compName.equalsIgnoreCase(name) || ignoreNew && pet.isNew()) continue;
            return pet;
        }
        return null;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.getId()).append("new", this.isNew()).append("lastName", (Object)this.getLastName()).append("firstName", (Object)this.getFirstName()).append("address", (Object)this.address).append("city", (Object)this.city).append("telephone", (Object)this.telephone).toString();
    }

    public void addVisit(Integer petId, Visit visit) {
        Assert.notNull((Object)petId, (String)"Pet identifier must not be null!");
        Assert.notNull((Object)visit, (String)"Visit must not be null!");
        Pet pet = this.getPet(petId);
        Assert.notNull((Object)pet, (String)"Invalid Pet identifier!");
        pet.addVisit(visit);
    }
}

